/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.config.IllagerAdditionsConfig;
import com.pikachu.mod.illager_more.entities.ai.AvoidAndApproachTargetGoal;
import com.pikachu.mod.illager_more.entities.effects.AttackEffects;
import com.pikachu.mod.illager_more.init.ModEntityTypes;
import com.pikachu.mod.illager_more.init.ModItems;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class NewCowboyEntity
extends AbstractIllager
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> IS_RELOAD = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PULLOUT = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PULL_IN = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PULLED_OUT = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> SHOOTING_TICK = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> IS_RUNNING = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DASH_ROLL = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ATTACK_FAST = SynchedEntityData.m_135353_(NewCowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final UUID MODIFIER_UUID = UUID.fromString("054d370b-0ff1-4ded-8630-b380232ed7b1");
    protected static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "increase", 1.0, AttributeModifier.Operation.ADDITION);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    protected int timer = 0;
    protected boolean canRoll;
    protected int aiStrength = (Integer)IllagerAdditionsConfig.cowboy_ai_strength.get();
    protected int bulletNum = 6;

    public NewCowboyEntity(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_DASH_ROLL, (Object)false);
        this.f_19804_.m_135372_(IS_RUNNING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_FAST, (Object)false);
        this.f_19804_.m_135372_(SHOOTING_TICK, (Object)0);
        this.f_19804_.m_135372_(IS_RELOAD, (Object)false);
        this.f_19804_.m_135372_(IS_PULLOUT, (Object)false);
        this.f_19804_.m_135372_(IS_PULL_IN, (Object)false);
        this.f_19804_.m_135372_(IS_PULLED_OUT, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.COWBOY_HAT.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.COWBOY_ROBES.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.COWBOY_PANTS.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.COWBOY_SHOES.get()));
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RunGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DashRollGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ReloadGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PullOutWeaponGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new WithdrawWeaponGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AvoidAndApproachTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 8.5f, 0.675, 1.1, true){

            @Override
            public void m_8037_() {
                LivingEntity livingentity = this.f_25015_.m_5448_();
                if (livingentity == null) {
                    return;
                }
                this.f_25015_.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + this.f_25015_.m_217043_().m_188503_(7);
                    this.f_25015_.m_21573_().m_5624_((Entity)livingentity, this.f_25024_);
                }
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && (Integer)this.f_19804_.m_135370_(SHOOTING_TICK) >= 9) {
            float f2;
            float f1;
            float f0;
            Vec3 endPos;
            Vec3 pos;
            Vec3 startPos;
            double yRot;
            int i;
            for (i = 0; i < 11; ++i) {
                yRot = this.f_20883_;
                startPos = CombatEvent.getOffsetPos((Entity)this, 0.0, 1.33, 1.45, (float)yRot);
                pos = CombatEvent.getOffsetPos((Entity)this, 0.0, 1.33, 2.25, (float)yRot);
                endPos = startPos.m_82549_(pos.m_82542_(-1.0, -1.0, -1.0));
                f0 = (float)(endPos.f_82479_ * 0.5 + this.m_217043_().m_188583_() * 0.85);
                f1 = (float)(endPos.f_82480_ * 0.5 + this.m_217043_().m_188583_() * 0.45);
                f2 = (float)(endPos.f_82481_ * 0.5 + this.m_217043_().m_188583_() * 0.85);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, (double)f0, (double)f1, (double)f2);
            }
            for (i = 0; i < 5; ++i) {
                yRot = this.f_20883_;
                startPos = CombatEvent.getOffsetPos((Entity)this, 0.0, 1.33, 1.45, (float)yRot);
                pos = CombatEvent.getOffsetPos((Entity)this, 0.0, 1.33, 1.85, (float)yRot);
                endPos = startPos.m_82549_(pos.m_82542_(-1.0, -1.0, -1.0));
                f0 = (float)(endPos.f_82479_ * 0.5 + this.m_217043_().m_188583_() * 0.65);
                f1 = (float)(endPos.f_82480_ * 0.5 + this.m_217043_().m_188583_() * 0.275);
                f2 = (float)(endPos.f_82481_ * 0.5 + this.m_217043_().m_188583_() * 0.65);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, (double)f0, (double)f1, (double)f2);
            }
        }
        if (!((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT)).booleanValue() || this.bulletNum <= 0 || ((Boolean)this.f_19804_.m_135370_(IS_RELOAD)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(ATTACK_FAST)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_DASH_ROLL)).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = this.m_5448_();
        if (livingEntity != null && this.m_6084_() && (Integer)this.f_19804_.m_135370_(SHOOTING_TICK) <= 0) {
            this.m_21563_().m_148051_((Entity)livingEntity);
            if (CombatEvent.getAreaEntity((LivingEntity)this, 4 * this.aiStrength, 8 * this.aiStrength, 0.1f, 8 * this.aiStrength, 80.0f).contains(livingEntity) && this.m_142582_((Entity)livingEntity)) {
                livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19366_(), 5.0f);
                --this.bulletNum;
                this.f_19804_.m_135381_(SHOOTING_TICK, (Object)10);
                this.shooting();
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if ((Integer)this.f_19804_.m_135370_(SHOOTING_TICK) > 0) {
            this.f_19804_.m_135381_(SHOOTING_TICK, (Object)((Integer)this.f_19804_.m_135370_(SHOOTING_TICK) - 1));
        }
    }

    protected void shooting() {
        if (!this.f_19853_.m_5776_()) {
            for (int i = 0; i <= 2; ++i) {
                float f = (float)Math.sqrt((this.m_20185_() - this.m_5448_().m_20185_()) * (this.m_20185_() - this.m_5448_().m_20185_()) + (this.m_20189_() - this.m_5448_().m_20189_()) * (this.m_20189_() - this.m_5448_().m_20189_()));
                float y = (float)(Math.atan2(this.m_20185_() - this.m_5448_().m_20185_(), this.m_20189_() - this.m_5448_().m_20189_()) * 57.29577951308232);
                float x = (float)(Mth.m_14136_((double)(this.m_20186_() - this.m_5448_().m_20186_()), (double)f) * 57.29577951308232);
                AttackEffects e = AttackEffects.spawnAttackEffect((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.f_19853_, 5, 90 * i, 1.1f, 1.4275f, 1, this.m_20270_((Entity)this.m_5448_()));
                e.m_20219_(this.m_5448_().m_20182_().m_82520_(0.0, 1.135, 0.0));
                e.setCaster((LivingEntity)this);
                e.m_146922_(Mth.m_14177_((float)y) + 90.0f);
                e.m_146926_((float)(-Mth.m_14175_((double)Math.toRadians(Math.sqrt(this.m_20186_() - this.m_5448_().m_20186_())))));
                e.f_19859_ = e.m_146908_();
                e.f_19860_ = e.m_146909_();
                this.f_19853_.m_7967_((Entity)e);
                this.m_216990_(SoundEvents.f_12313_);
            }
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_ || p_33314_ instanceof Raider) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    @Nonnull
    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource p_184601_1_) {
        return SoundEvents.f_12579_;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "r", 0.0f, this::predicateRot));
    }

    protected boolean aBoolean() {
        return this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_142582_((Entity)this.m_5448_());
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimationSpeed(1.0);
        NewCowboyEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (((Boolean)this.f_19804_.m_135370_(IS_PULLOUT)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("pull_out", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_PULL_IN)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("pull_down", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_RELOAD)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("reload_bullet", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(ATTACK_FAST)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack_fast", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH_ROLL)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("roll", Boolean.valueOf(true)));
        } else {
            double animationSpeed1 = Math.max(Math.min((double)(groundSpeed * 20.0f), 2.1), 0.15);
            if (((Boolean)this.f_19804_.m_135370_(IS_RUNNING)).booleanValue()) {
                event.getController().setAnimationSpeed(animationSpeed1);
                event.getController().setAnimation(new AnimationBuilder().addAnimation("run_and_attack", Boolean.valueOf(true)));
            } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimationSpeed(animationSpeed1);
                event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT) != false ? "walk_pulled_out_weapon" : "walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT) != false ? "idle_pulled_out_weapon" : "idle", Boolean.valueOf(true)));
            }
        }
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState predicateRot(AnimationEvent<P> event) {
        event.getController().setAnimationSpeed(1.0);
        if (((Boolean)this.f_19804_.m_135370_(IS_RELOAD)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot4", Boolean.valueOf(true)));
        } else if ((Integer)this.f_19804_.m_135370_(SHOOTING_TICK) > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("shooting", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH_ROLL)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("new", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class RunGoal
    extends Goal {
        private final NewCowboyEntity mob;
        protected Path path;
        protected final PathNavigation pathNav;

        public RunGoal(NewCowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
            this.pathNav = entity.m_21573_();
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (this.mob.m_20270_((Entity)this.mob.m_5448_()) > 12.0f || (double)this.mob.m_20270_((Entity)this.mob.m_5448_()) < 5.5) && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT) != false && this.mob.bulletNum > 0 && this.mob.aiStrength > 2;
        }

        public boolean m_6767_() {
            return this.mob.timer >= 120;
        }

        public boolean m_8045_() {
            return !((this.path != null && !this.path.m_77392_() || this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (!this.mob.m_5448_().m_142582_((Entity)this.mob) || !this.mob.m_5448_().m_21093_(itemStack -> itemStack.m_41720_() instanceof ProjectileWeaponItem && this.mob.m_5448_().m_6117_()) && !CombatEvent.getAreaEntity(this.mob.m_5448_(), 64.0f, 66.0f, 24.0f, 66.0f, 60.0f).contains((Object)this.mob))) && this.mob.timer > 40 || this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_() || this.mob.timer > 260 || this.mob.bulletNum <= 0);
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.path = null;
            this.mob.m_21573_().m_26573_();
            this.mob.f_19804_.m_135381_(IS_RUNNING, (Object)Boolean.TRUE);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_RUNNING, (Object)false);
            this.mob.m_21573_().m_26573_();
            this.path = null;
            Vec3 vec3 = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 5.0, this.mob.f_20883_);
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity == null || !livingEntity.m_6084_()) {
                return;
            }
            this.mob.canRoll = livingEntity.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.mob.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) || !RunGoal.hasLineOfSight(vec3, livingEntity);
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity == null || !livingEntity.m_6084_()) {
                return;
            }
            ++this.mob.timer;
            this.mob.m_21563_().m_148051_((Entity)livingEntity);
            if (this.path != null && !this.path.m_77392_() || this.mob.f_19797_ % 48 == 0) {
                return;
            }
            this.path = null;
            if ((double)this.mob.m_20270_((Entity)this.mob.m_5448_()) < 5.5) {
                boolean avoidingTarget;
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)24, (int)11, (Vec3)livingEntity.m_20182_());
                    if (vec3 == null || livingEntity.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.mob.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) continue;
                    if (RunGoal.hasLineOfSight(vec3, livingEntity)) {
                        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                        break;
                    }
                    this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                    break;
                }
                boolean bl = avoidingTarget = this.path != null;
                if (avoidingTarget) {
                    this.mob.m_21573_().m_26536_(this.path, 1.875);
                }
            } else {
                boolean avoidingTarget;
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)12, (int)6, (Vec3)this.mob.m_20182_());
                    if (vec3 == null || Math.sqrt(this.mob.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) < 3.5 || !(Math.sqrt(this.mob.m_5448_().m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) > 5.5) || !(Math.sqrt(this.mob.m_5448_().m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) < 17.0)) continue;
                    if (RunGoal.hasLineOfSight(vec3, livingEntity)) {
                        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                        break;
                    }
                    this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                    break;
                }
                if (this.path == null) {
                    Vec3 vec3 = this.mob.m_5448_().m_20182_().m_82549_(this.mob.m_20182_()).m_82542_(0.5, 0.5, 0.5);
                    this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                }
                boolean bl = avoidingTarget = this.path != null;
                if (avoidingTarget) {
                    this.mob.m_21573_().m_26536_(this.path, 1.715);
                }
            }
        }

        public static boolean hasLineOfSight(Vec3 p_147185_, LivingEntity m) {
            Vec3 vec3 = new Vec3(m.m_20185_(), m.m_20188_(), m.m_20189_());
            if (p_147185_.m_82554_(vec3) > 128.0) {
                return false;
            }
            return m.f_19853_.m_45547_(new ClipContext(vec3, p_147185_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)m)).m_6662_() == HitResult.Type.MISS;
        }

        protected void sound(int i) {
            if (this.mob.timer == i) {
                this.mob.m_5496_(SoundEvents.f_12444_, 0.7f, 0.6f);
            }
        }
    }

    static class DashRollGoal
    extends Goal {
        private final NewCowboyEntity mob;
        private static final int dodgeTimerTakesEffect = 9;
        private float dodgeYaw;

        public DashRollGoal(NewCowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.canRoll && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT) != false;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 9 || !this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20069_();
        }

        public void m_8056_() {
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            if (!modifiableattributeinstance.m_22109_(MODIFIER)) {
                modifiableattributeinstance.m_22118_(MODIFIER);
            }
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DASH_ROLL, (Object)true);
        }

        public void m_8041_() {
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            modifiableattributeinstance.m_22130_(MODIFIER);
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DASH_ROLL, (Object)false);
            this.mob.canRoll = false;
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 1) {
                this.dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 60.0f - 30.0f);
            }
            if (this.mob.timer == 6) {
                float speed = 2.5f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.1, m.f_82481_);
            }
        }
    }

    static class ReloadGoal
    extends Goal {
        private final NewCowboyEntity mob;

        public ReloadGoal(NewCowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) && this.mob.bulletNum < 6 || this.mob.bulletNum <= 0 || this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && !this.mob.m_142582_((Entity)this.mob.m_5448_()) && this.mob.bulletNum < 3;
        }

        public boolean m_6767_() {
            return this.mob.timer >= 10;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_RELOAD, (Object)Boolean.TRUE);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_RELOAD, (Object)false);
            this.mob.bulletNum = 6;
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.timer == 2) {
                this.mob.m_5496_(SoundEvents.f_12482_, 0.8f, 0.5f);
            }
            this.sound(7);
            this.sound(9);
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }

        protected void sound(int i) {
            if (this.mob.timer == i) {
                this.mob.m_5496_(SoundEvents.f_12444_, 0.7f, 0.6f);
            }
        }
    }

    static class PullOutWeaponGoal
    extends Goal {
        private final NewCowboyEntity mob;

        public PullOutWeaponGoal(NewCowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT) == false;
        }

        public boolean m_6767_() {
            return this.mob.timer >= 5;
        }

        public boolean m_8045_() {
            return this.mob.timer < 10;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLOUT, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT, (Object)true);
            this.mob.f_19804_.m_135381_(IS_PULLOUT, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class WithdrawWeaponGoal
    extends Goal {
        private final NewCowboyEntity mob;

        public WithdrawWeaponGoal(NewCowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT) != false && this.mob.bulletNum == 6;
        }

        public boolean m_8045_() {
            return this.mob.timer < 10;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULL_IN, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT, (Object)false);
            this.mob.f_19804_.m_135381_(IS_PULL_IN, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class DoHurtTargetGoal
    extends Goal {
        protected final NewCowboyEntity mob;
        protected int type;
        protected int cooldown;
        protected boolean canMoving;
        protected boolean hasNext;

        public DoHurtTargetGoal(NewCowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (double)this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 7.5 && this.mob.m_142582_((Entity)this.mob.m_5448_()) && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT) != false && this.cooldown <= this.mob.f_19797_ && this.mob.bulletNum >= 3;
        }

        public boolean m_8045_() {
            if (!this.hasNext) {
                return this.isAttacking() && this.mob.m_5448_() != null;
            }
            if (!this.isAttacking()) {
                this.mob.timer = 0;
                ++this.type;
                if (this.mob.bulletNum <= 0) {
                    return false;
                }
                return this.mob.m_217043_().m_188499_() && this.mob.m_5448_() != null && this.mob.m_5448_().f_20916_ > 0;
            }
            return this.mob.m_5448_() != null;
        }

        private boolean isAttacking() {
            return this.mob.timer < (this.type == 1 ? 10 : 25) + 1 - this.mob.m_217043_().m_188503_(3) && this.mob.bulletNum > 0;
        }

        public boolean m_6767_() {
            return this.mob.f_20916_ > 0 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) < 6.0f;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.type = 2;
            this.mob.f_19804_.m_135381_(ATTACK_FAST, (Object)true);
        }

        public void m_8037_() {
            ++this.mob.timer;
            if (this.type == 1) {
                this.attack(2);
                this.hasNext = false;
                this.canMoving = false;
            } else if (this.type == 2) {
                this.attack(9);
                this.attack(11);
                this.attack(13);
                this.attack(15);
                this.attack(17);
                this.attack(19);
                this.hasNext = false;
            }
            if (this.mob.m_5448_() == null) {
                this.hasNext = false;
            }
            if (!this.canMoving) {
                this.mob.m_21573_().m_26573_();
            }
            if (this.mob.m_5448_() != null) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
            }
        }

        private void attack(int i) {
            if (this.mob.timer == i) {
                if (this.mob.m_5448_() == null) {
                    return;
                }
                if (CombatEvent.getAreaEntity((LivingEntity)this.mob, 128.0f, 64.0f, 48.0f, 64.0f, 80.0f).contains(this.mob.m_5448_())) {
                    this.mob.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this.mob).m_19366_(), 6.777f);
                    --this.mob.bulletNum;
                    float f = (float)Math.sqrt((this.mob.m_20185_() - this.mob.m_5448_().m_20185_()) * (this.mob.m_20185_() - this.mob.m_5448_().m_20185_()) + (this.mob.m_20189_() - this.mob.m_5448_().m_20189_()) * (this.mob.m_20189_() - this.mob.m_5448_().m_20189_()));
                    float y = (float)(Math.atan2(this.mob.m_20185_() - this.mob.m_5448_().m_20185_(), this.mob.m_20189_() - this.mob.m_5448_().m_20189_()) * 57.29577951308232);
                    float x = (float)(Mth.m_14136_((double)(this.mob.m_20186_() - this.mob.m_5448_().m_20186_()), (double)f) * 57.29577951308232);
                    AttackEffects e = AttackEffects.spawnAttackEffect((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 5, 90 * i, 1.1f, 1.4275f, 1, this.mob.m_20270_((Entity)this.mob.m_5448_()));
                    e.m_20219_(this.mob.m_5448_().m_20182_().m_82520_(0.0, 1.135, 0.0));
                    e.setCaster((LivingEntity)this.mob);
                    e.m_146922_(Mth.m_14177_((float)y) + 90.0f + (float)this.mob.m_217043_().m_188503_(12) - 6.0f);
                    e.m_146926_(-Mth.m_14177_((float)(-x)) + (float)this.mob.m_217043_().m_188503_(12) - 6.0f);
                    e.f_19859_ = e.m_146908_();
                    e.f_19860_ = e.m_146909_();
                    this.mob.f_19853_.m_7967_((Entity)e);
                    this.mob.m_216990_(SoundEvents.f_12313_);
                }
            }
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(ATTACK_FAST, (Object)false);
            this.cooldown = this.mob.f_19797_ + 120;
        }
    }
}

